
clc, clear all, close all;
format long;
tic;

%%%%%%%%%%%%%%%%%%%%% Desired Evaluation Point of Shell
xd = 0.5;   yd = pi/2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mw = 1;  nw = 1 ;  mu = 1; nu = 1; mv = 1; nv = 1;
% mw = 2;  nw = 1 ;  mu = 2; nu = 1; mv = 2; nv = 1;
% mw = 3;  nw = 1 ;  mu = 3; nu = 1; mv = 3; nv = 1;
% mw = 1;  nw = 2 ;  mu = 1; nu = 2; mv = 1; nv = 2;
% mw = 1;  nw = 3 ;  mu = 1; nu = 3; mv = 1; nv = 3;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% SS
load(['data_SSL1_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_1','Kuu1_1','Kuu2_1','Kuv1_1','Kuv2_1','Kuw1_1','NLuw1_1','NLuw2_1',...
    'NLuw3_1','Fu1_1','Mvv1_1','Kvv1_1','Kvv2_1','Kvu1_1','Kvu2_1','Kvw1_1','NLvw1_1','NLvw2_1','NLvw3_1','Fv1_1','Mww1_1',...
    'Mww2_1','Mww3_1','Cww1_1','Kww1_1','Kww2_1','Kww3_1','Kww4_1','Kww5_1','Kww6_1','Kww7_1','Kwvdw_1','Kbarw1_1',...
    'Kbarp1_1','Kbarp2_1','Kew1_1','Kwu1_1','Kwv1_1','NLwu1_1','NLwu2_1','NLwu3_1','NLwu4_1','NLwv1_1','NLwv2_1','NLwv3_1',...
    'NLwv4_1','NLww1_1','NLww2_1','NLww3_1','NLww4_1','NLew2_1','NLwww1_1','NLwww2_1','NLwww3_1','NLwww4_1','NLew3_1','NLvdw_1',...
    'Fw1_1','Fw2_1','Fw3_1','Fbar1_1');
load(['data_SSL2_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_2','Kuu1_2','Kuu2_2','Kuv1_2','Kuv2_2','Kuw1_2','NLuw1_2','NLuw2_2',...
    'NLuw3_2','Fu1_2','Mvv1_2','Kvv1_2','Kvv2_2','Kvu1_2','Kvu2_2','Kvw1_2','NLvw1_2','NLvw2_2','NLvw3_2','Fv1_2','Mww1_2',...
    'Mww2_2','Mww3_2','Cww1_2','Kww1_2','Kww2_2','Kww3_2','Kww4_2','Kww5_2','Kww6_2','Kww7_2','Kwvdw_2','Kbarw1_2',...
    'Kbarp1_2','Kbarp2_2','Kew1_2','Kwu1_2','Kwv1_2','NLwu1_2','NLwu2_2','NLwu3_2','NLwu4_2','NLwv1_2','NLwv2_2','NLwv3_2',...
    'NLwv4_2','NLww1_2','NLww2_2','NLww3_2','NLww4_2','NLew2_2','NLwww1_2','NLwww2_2','NLwww3_2','NLwww4_2','NLew3_2','NLvdw_2',...
    'Fw1_2','Fw2_2','Fw3_2','Fbar1_2');
load(['data_SSL3_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_3','Kuu1_3','Kuu2_3','Kuv1_3','Kuv2_3','Kuw1_3','NLuw1_3','NLuw2_3',...
    'NLuw3_3','Fu1_3','Mvv1_3','Kvv1_3','Kvv2_3','Kvu1_3','Kvu2_3','Kvw1_3','NLvw1_3','NLvw2_3','NLvw3_3','Fv1_3','Mww1_3',...
    'Mww2_3','Mww3_3','Cww1_3','Kww1_3','Kww2_3','Kww3_3','Kww4_3','Kww5_3','Kww6_3','Kww7_3','Kwvdw_3','Kbarw1_3',...
    'Kbarp1_3','Kbarp2_3','Kew1_3','Kwu1_3','Kwv1_3','NLwu1_3','NLwu2_3','NLwu3_3','NLwu4_3','NLwv1_3','NLwv2_3','NLwv3_3',...
    'NLwv4_3','NLww1_3','NLww2_3','NLww3_3','NLww4_3','NLew2_3','NLwww1_3','NLwww2_3','NLwww3_3','NLwww4_3','NLew3_3','NLvdw_3',...
    'Fw1_3','Fw2_3','Fw3_3','Fbar1_3');
load data_T_SS_x   Bx   Coeffx
load data_T_SS_y   By   Coeffy
load data_M_SS_x  Omega_x  Coeffx_Bar
load data_M_SS_y  Omega_y  Coeffy_Bar

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% CC
% load(['data_CCL1_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_1','Kuu1_1','Kuu2_1','Kuv1_1','Kuv2_1','Kuw1_1','NLuw1_1','NLuw2_1',...
%     'NLuw3_1','Fu1_1','Mvv1_1','Kvv1_1','Kvv2_1','Kvu1_1','Kvu2_1','Kvw1_1','NLvw1_1','NLvw2_1','NLvw3_1','Fv1_1','Mww1_1',...
%     'Mww2_1','Mww3_1','Cww1_1','Kww1_1','Kww2_1','Kww3_1','Kww4_1','Kww5_1','Kww6_1','Kww7_1','Kwvdw_1','Kbarw1_1',...
%     'Kbarp1_1','Kbarp2_1','Kew1_1','Kwu1_1','Kwv1_1','NLwu1_1','NLwu2_1','NLwu3_1','NLwu4_1','NLwv1_1','NLwv2_1','NLwv3_1',...
%     'NLwv4_1','NLww1_1','NLww2_1','NLww3_1','NLww4_1','NLew2_1','NLwww1_1','NLwww2_1','NLwww3_1','NLwww4_1','NLew3_1','NLvdw_1',...
%     'Fw1_1','Fw2_1','Fw3_1','Fbar1_1');
% load(['data_CCL2_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_2','Kuu1_2','Kuu2_2','Kuv1_2','Kuv2_2','Kuw1_2','NLuw1_2','NLuw2_2',...
%     'NLuw3_2','Fu1_2','Mvv1_2','Kvv1_2','Kvv2_2','Kvu1_2','Kvu2_2','Kvw1_2','NLvw1_2','NLvw2_2','NLvw3_2','Fv1_2','Mww1_2',...
%     'Mww2_2','Mww3_2','Cww1_2','Kww1_2','Kww2_2','Kww3_2','Kww4_2','Kww5_2','Kww6_2','Kww7_2','Kwvdw_2','Kbarw1_2',...
%     'Kbarp1_2','Kbarp2_2','Kew1_2','Kwu1_2','Kwv1_2','NLwu1_2','NLwu2_2','NLwu3_2','NLwu4_2','NLwv1_2','NLwv2_2','NLwv3_2',...
%     'NLwv4_2','NLww1_2','NLww2_2','NLww3_2','NLww4_2','NLew2_2','NLwww1_2','NLwww2_2','NLwww3_2','NLwww4_2','NLew3_2','NLvdw_2',...
%     'Fw1_2','Fw2_2','Fw3_2','Fbar1_2');
% load(['data_CCL3_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_3','Kuu1_3','Kuu2_3','Kuv1_3','Kuv2_3','Kuw1_3','NLuw1_3','NLuw2_3',...
%     'NLuw3_3','Fu1_3','Mvv1_3','Kvv1_3','Kvv2_3','Kvu1_3','Kvu2_3','Kvw1_3','NLvw1_3','NLvw2_3','NLvw3_3','Fv1_3','Mww1_3',...
%     'Mww2_3','Mww3_3','Cww1_3','Kww1_3','Kww2_3','Kww3_3','Kww4_3','Kww5_3','Kww6_3','Kww7_3','Kwvdw_3','Kbarw1_3',...
%     'Kbarp1_3','Kbarp2_3','Kew1_3','Kwu1_3','Kwv1_3','NLwu1_3','NLwu2_3','NLwu3_3','NLwu4_3','NLwv1_3','NLwv2_3','NLwv3_3',...
%     'NLwv4_3','NLww1_3','NLww2_3','NLww3_3','NLww4_3','NLew2_3','NLwww1_3','NLwww2_3','NLwww3_3','NLwww4_3','NLew3_3','NLvdw_3',...
%     'Fw1_3','Fw2_3','Fw3_3','Fbar1_3');
% load data_T_CC_x   Bx   Coeffx
% load data_T_CC_y   By   Coeffy
% load data_M_CC_x  Omega_x  Coeffx_Bar
% load data_M_CC_y  Omega_y  Coeffy_Bar

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% CS
% load(['data_CSL1_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_1','Kuu1_1','Kuu2_1','Kuv1_1','Kuv2_1','Kuw1_1','NLuw1_1','NLuw2_1',...
%     'NLuw3_1','Fu1_1','Mvv1_1','Kvv1_1','Kvv2_1','Kvu1_1','Kvu2_1','Kvw1_1','NLvw1_1','NLvw2_1','NLvw3_1','Fv1_1','Mww1_1',...
%     'Mww2_1','Mww3_1','Cww1_1','Kww1_1','Kww2_1','Kww3_1','Kww4_1','Kww5_1','Kww6_1','Kww7_1','Kwvdw_1','Kbarw1_1',...
%     'Kbarp1_1','Kbarp2_1','Kew1_1','Kwu1_1','Kwv1_1','NLwu1_1','NLwu2_1','NLwu3_1','NLwu4_1','NLwv1_1','NLwv2_1','NLwv3_1',...
%     'NLwv4_1','NLww1_1','NLww2_1','NLww3_1','NLww4_1','NLew2_1','NLwww1_1','NLwww2_1','NLwww3_1','NLwww4_1','NLew3_1','NLvdw_1',...
%     'Fw1_1','Fw2_1','Fw3_1','Fbar1_1');
% load(['data_CSL2_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_2','Kuu1_2','Kuu2_2','Kuv1_2','Kuv2_2','Kuw1_2','NLuw1_2','NLuw2_2',...
%     'NLuw3_2','Fu1_2','Mvv1_2','Kvv1_2','Kvv2_2','Kvu1_2','Kvu2_2','Kvw1_2','NLvw1_2','NLvw2_2','NLvw3_2','Fv1_2','Mww1_2',...
%     'Mww2_2','Mww3_2','Cww1_2','Kww1_2','Kww2_2','Kww3_2','Kww4_2','Kww5_2','Kww6_2','Kww7_2','Kwvdw_2','Kbarw1_2',...
%     'Kbarp1_2','Kbarp2_2','Kew1_2','Kwu1_2','Kwv1_2','NLwu1_2','NLwu2_2','NLwu3_2','NLwu4_2','NLwv1_2','NLwv2_2','NLwv3_2',...
%     'NLwv4_2','NLww1_2','NLww2_2','NLww3_2','NLww4_2','NLew2_2','NLwww1_2','NLwww2_2','NLwww3_2','NLwww4_2','NLew3_2','NLvdw_2',...
%     'Fw1_2','Fw2_2','Fw3_2','Fbar1_2');
% load(['data_CSL3_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_3','Kuu1_3','Kuu2_3','Kuv1_3','Kuv2_3','Kuw1_3','NLuw1_3','NLuw2_3',...
%     'NLuw3_3','Fu1_3','Mvv1_3','Kvv1_3','Kvv2_3','Kvu1_3','Kvu2_3','Kvw1_3','NLvw1_3','NLvw2_3','NLvw3_3','Fv1_3','Mww1_3',...
%     'Mww2_3','Mww3_3','Cww1_3','Kww1_3','Kww2_3','Kww3_3','Kww4_3','Kww5_3','Kww6_3','Kww7_3','Kwvdw_3','Kbarw1_3',...
%     'Kbarp1_3','Kbarp2_3','Kew1_3','Kwu1_3','Kwv1_3','NLwu1_3','NLwu2_3','NLwu3_3','NLwu4_3','NLwv1_3','NLwv2_3','NLwv3_3',...
%     'NLwv4_3','NLww1_3','NLww2_3','NLww3_3','NLww4_3','NLew2_3','NLwww1_3','NLwww2_3','NLwww3_3','NLwww4_3','NLew3_3','NLvdw_3',...
%     'Fw1_3','Fw2_3','Fw3_3','Fbar1_3');
% load data_T_CS_x   Bx   Coeffx
% load data_T_CS_y   By   Coeffy
% load data_M_CS_x  Omega_x  Coeffx_Bar
% load data_M_CS_y  Omega_y  Coeffy_Bar

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% CF
% load(['data_CFL1_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_1','Kuu1_1','Kuu2_1','Kuv1_1','Kuv2_1','Kuw1_1','NLuw1_1','NLuw2_1',...
%     'NLuw3_1','Fu1_1','Mvv1_1','Kvv1_1','Kvv2_1','Kvu1_1','Kvu2_1','Kvw1_1','NLvw1_1','NLvw2_1','NLvw3_1','Fv1_1','Mww1_1',...
%     'Mww2_1','Mww3_1','Cww1_1','Kww1_1','Kww2_1','Kww3_1','Kww4_1','Kww5_1','Kww6_1','Kww7_1','Kwvdw_1','Kbarw1_1',...
%     'Kbarp1_1','Kbarp2_1','Kew1_1','Kwu1_1','Kwv1_1','NLwu1_1','NLwu2_1','NLwu3_1','NLwu4_1','NLwv1_1','NLwv2_1','NLwv3_1',...
%     'NLwv4_1','NLww1_1','NLww2_1','NLww3_1','NLww4_1','NLew2_1','NLwww1_1','NLwww2_1','NLwww3_1','NLwww4_1','NLew3_1','NLvdw_1',...
%     'Fw1_1','Fw2_1','Fw3_1','Fbar1_1');
% load(['data_CFL2_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_2','Kuu1_2','Kuu2_2','Kuv1_2','Kuv2_2','Kuw1_2','NLuw1_2','NLuw2_2',...
%     'NLuw3_2','Fu1_2','Mvv1_2','Kvv1_2','Kvv2_2','Kvu1_2','Kvu2_2','Kvw1_2','NLvw1_2','NLvw2_2','NLvw3_2','Fv1_2','Mww1_2',...
%     'Mww2_2','Mww3_2','Cww1_2','Kww1_2','Kww2_2','Kww3_2','Kww4_2','Kww5_2','Kww6_2','Kww7_2','Kwvdw_2','Kbarw1_2',...
%     'Kbarp1_2','Kbarp2_2','Kew1_2','Kwu1_2','Kwv1_2','NLwu1_2','NLwu2_2','NLwu3_2','NLwu4_2','NLwv1_2','NLwv2_2','NLwv3_2',...
%     'NLwv4_2','NLww1_2','NLww2_2','NLww3_2','NLww4_2','NLew2_2','NLwww1_2','NLwww2_2','NLwww3_2','NLwww4_2','NLew3_2','NLvdw_2',...
%     'Fw1_2','Fw2_2','Fw3_2','Fbar1_2');
% load(['data_CFL3_' int2str([mw,nw,mu,nu,mv,nv])],'Muu1_3','Kuu1_3','Kuu2_3','Kuv1_3','Kuv2_3','Kuw1_3','NLuw1_3','NLuw2_3',...
%     'NLuw3_3','Fu1_3','Mvv1_3','Kvv1_3','Kvv2_3','Kvu1_3','Kvu2_3','Kvw1_3','NLvw1_3','NLvw2_3','NLvw3_3','Fv1_3','Mww1_3',...
%     'Mww2_3','Mww3_3','Cww1_3','Kww1_3','Kww2_3','Kww3_3','Kww4_3','Kww5_3','Kww6_3','Kww7_3','Kwvdw_3','Kbarw1_3',...
%     'Kbarp1_3','Kbarp2_3','Kew1_3','Kwu1_3','Kwv1_3','NLwu1_3','NLwu2_3','NLwu3_3','NLwu4_3','NLwv1_3','NLwv2_3','NLwv3_3',...
%     'NLwv4_3','NLww1_3','NLww2_3','NLww3_3','NLww4_3','NLew2_3','NLwww1_3','NLwww2_3','NLwww3_3','NLwww4_3','NLew3_3','NLvdw_3',...
%     'Fw1_3','Fw2_3','Fw3_3','Fbar1_3');
% load data_T_CF_x   Bx   Coeffx
% load data_T_CF_y   By   Coeffy
% load data_M_CF_x  Omega_x  Coeffx_Bar
% load data_M_CF_y  Omega_y  Coeffy_Bar

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Test Data ((Al % PZT))
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Layer 1
Upsilon1=0; Vb01=0; V_dc1=0; V_ac1=0; b1=0; Kw1=0; Kp1=0; zeta1=0; Cw1=0; Vp1=0; hp1=0; e31_ps1=0;
e32_ps1=0; landa_ps1=0; mu_ps1=0; tha0_ps1=0; Ep1=0; nup1=0; rop1=0; e31p1=0; e32p1=0; ro_ps1=0;
R1=1e-9; L=linspace(2, 30, 2e1)*R1; hN1=0.01*R1; EN1=70e9; nuN1=0.33; roN1=2700; landa_NI1=3.786; mu_NI1=1.95;
tha0_NI1=0.9108e0; ro_NI1=5.46e-8; CvdwL1=9.91866693e19; CvdwNL1=2.201667e31;
I1=2*roN1*hN1+rop1*hp1+ro_NI1+ro_ps1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Layer 2
Upsilon2=0; Vb02=0; V_dc2=0; V_ac2=0; b2=0; Kw2=0; Kp2=0; zeta2=0; Cw2=0; Vp2=0; hp2=0; e31_ps2=0;
e32_ps2=0; landa_ps2=0; mu_ps2=0; tha0_ps2=0; Ep2=0; nup2=0; rop2=0; e31p2=0; e32p2=0; ro_ps2=0;
R2=1.5e-9; hN2=0.01*R1; EN2=70e9; nuN2=0.33; roN2=2700; landa_NI2=3.786; mu_NI2=1.95;
tha0_NI2=0.9108e0; ro_NI2=5.46e-8; CvdwL2=9.91866693e18; CvdwNL2=2.201667e30;
I2=2*roN2*hN2+rop2*hp2+ro_NI2+ro_ps2;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Layer 3
Upsilon3=8.85e-12; Vb03=1; V_dc3=15; V_ac3 =10; Kw3=8.9995035e17; Kp3=2.071273; Cw3=1e-5; zeta3=1e-7; Vp3=5e-1; 
R3=2e-9; b3 =0.1*R3; hN3=0.01*R1; hp3=0.005*R1; CvdwL3=9.91866693e20; CvdwNL3=2.201667e32; 
EN3=70e9; nuN3=0.33; roN3=2700; landa_NI3=3.786; mu_NI3=1.95; tha0_NI3=0.9108e0; ro_NI3=5.46e-8; 
Ep3=95e9; nup3=0.3; rop3=7500; landa_ps3=4.488; mu_ps3=2.774; tha0_ps3=0.6e0; ro_ps3=5.61e-7; 
e31p3=-5.2; e32p3=-5.2; e31_ps3=-3e-8; e32_ps3=-3e-8;     
I3=2*roN3*hN3+rop3*hp3+ro_NI3+ro_ps3;    

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Without S/I
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Layer 1
% Upsilon1=0; Vb01=0; V_dc1=0; V_ac1=0; b1=0; Kw1=0; Kp1=0; zeta1=0; Cw1=0; Vp1=0; hp1=0; e31_ps1=0;
% e32_ps1=0; landa_ps1=0; mu_ps1=0; tha0_ps1=0; Ep1=0; nup1=0; rop1=0; e31p1=0; e32p1=0; ro_ps1=0;
% R1=1e-9; L=linspace(2, 30, 2e1)*R1; hN1=0.01*R1; EN1=70e9; nuN1=0.33; roN1=2700; landa_NI1=0; mu_NI1=0;
% tha0_NI1=0; ro_NI1=0; CvdwL1=9.91866693e19; CvdwNL1=2.201667e31;
% I1=2*roN1*hN1+rop1*hp1+ro_NI1+ro_ps1;
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Layer 2
% Upsilon2=0; Vb02=0; V_dc2=0; V_ac2=0; b2=0; Kw2=0; Kp2=0; zeta2=0; Cw2=0; Vp2=0; hp2=0; e31_ps2=0;
% e32_ps2=0; landa_ps2=0; mu_ps2=0; tha0_ps2=0; Ep2=0; nup2=0; rop2=0; e31p2=0; e32p2=0; ro_ps2=0;
% R2=1.5e-9; hN2=0.01*R1; EN2=70e9; nuN2=0.33; roN2=2700; landa_NI2=0; mu_NI2=0;
% tha0_NI2=0; ro_NI2=0; CvdwL2=9.91866693e18; CvdwNL2=2.201667e30;
% I2=2*roN2*hN2+rop2*hp2+ro_NI2+ro_ps2;
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Layer 3
% Upsilon3=8.85e-12; Vb03=1; V_dc3=15; V_ac3 =10; Kw3=8.9995035e17; Kp3=2.071273; Cw3=1e-5; zeta3=1e-7; Vp3=5e-5; 
% R3=2e-9; b3 =0.1*R3; hN3=0.01*R1; hp3=0.005*R1; CvdwL3=9.91866693e20; CvdwNL3=2.201667e32; 
% EN3=70e9; nuN3=0.33; roN3=2700; landa_NI3=0; mu_NI3=0; tha0_NI3=0; ro_NI3=0; 
% Ep3=95e9; nup3=0.3; rop3=7500; landa_ps3=0; mu_ps3=0; tha0_ps3=0; ro_ps3=0; 
% e31p3=-5.2; e32p3=-5.2; e31_ps3=0; e32_ps3=0;     
% I3=2*roN3*hN3+rop3*hp3+ro_NI3+ro_ps3; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Actual Data
% Cw= 4.491989398e-7; Kw=8.9995035e17; Kp=2.071273; landas=4.488; mus=2.774; tha0s=0.6;
% CvdwL1=9.91866693e19; CvdwNL1=2.201667e31;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Materail Properties2
C11N1=EN1/(1-nuN1^2); C22N1=EN1/(1-nuN1^2); C12N1=(nuN1*EN1)/(1-nuN1^2); C21N1=(nuN1*EN1)/(1-nuN1^2); C66N1=EN1/(2*(1+nuN1));
C11p1=Ep1/(1-nup1^2); C22p1=Ep1/(1-nup1^2); C12p1=(nup1*Ep1)/(1-nup1^2); C21p1=(nup1*Ep1)/(1-nup1^2); C66p1=Ep1/(2*(1+nup1));
Ezp1=0;
C11N2=EN2/(1-nuN2^2); C22N2=EN2/(1-nuN2^2); C12N2=(nuN2*EN2)/(1-nuN2^2); C21N2=(nuN2*EN2)/(1-nuN2^2); C66N2=EN2/(2*(1+nuN2));
C11p2=Ep2/(1-nup2^2); C22p2=Ep2/(1-nup2^2); C12p2=(nup2*Ep2)/(1-nup2^2); C21p2=(nup2*Ep2)/(1-nup2^2); C66p2=Ep2/(2*(1+nup2));
Ezp2=0;
C11N3=EN3/(1-nuN3^2); C22N3=EN3/(1-nuN3^2); C12N3=(nuN3*EN3)/(1-nuN3^2); C21N3=(nuN3*EN3)/(1-nuN3^2); C66N3=EN3/(2*(1+nuN3));
C11p3=Ep3/(1-nup3^2); C22p3=Ep3/(1-nup3^2); C12p3=(nup3*Ep3)/(1-nup3^2); C21p3=(nup3*Ep3)/(1-nup3^2); C66p3=Ep3/(2*(1+nup3));
Ezp3 = Vp3/hp3;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Geometric parameters layer 1
A11N1=2*hN1*C11N1; A22N1=2*hN1*C22N1; A21N1=2*hN1*C21N1; A12N1=2*hN1*C12N1; A66N1=2*hN1*C66N1;
D11N1=(2/3)*C11N1*hN1^3;D22N1=(2/3)*C22N1*hN1^3;D12N1=(2/3)*C12N1*hN1^3; D21N1=(2/3)*C21N1*hN1^3;  
D66N1=(2/3)*C66N1*hN1^3;A11p1=2*hp1*C11p1; A22p1=2*hp1*C22p1; A12p1=2*hp1*C12p1; A21p1=2*hp1*C21p1; A66p1=2*hp1*C66p1;
D11p1=(C11p1/3)*((-hN1)^3-(-hN1-hp1)^3)+(C11p1/3)*((hN1+hp1)^3-(hN1)^3);D12p1=(C12p1/3)*((-hN1)^3-(-hN1-hp1)^3)+(C12p1/3)*((hN1+hp1)^3-(hN1)^3);
D21p1=(C21p1/3)*((-hN1)^3-(-hN1-hp1)^3)+(C21p1/3)*((hN1+hp1)^3-(hN1)^3);D22p1=(C22p1/3)*((-hN1)^3-(-hN1-hp1)^3)+(C22p1/3)*((hN1+hp1)^3-(hN1)^3);
D66p1=(C66p1/3)*((-hN1)^3-(-hN1-hp1)^3)+(C66p1/3)*((hN1+hp1)^3-(hN1)^3);
A1101=2*(landa_NI1+(2*mu_NI1))+2*(landa_ps1+(2*mu_ps1));A2201=2*(landa_NI1+(2*mu_NI1))+2*(landa_ps1+(2*mu_ps1));
A1201=2*(tha0_NI1+landa_NI1)+2*(tha0_ps1+landa_ps1);A2101=2*(tha0_NI1+landa_NI1)+2*(tha0_ps1+landa_ps1);
A6601=2*mu_NI1-tha0_NI1+2*mu_ps1-tha0_ps1;D1101=2*(landa_NI1+(2*mu_NI1))*(hN1^2)+2*(landa_ps1+(2*mu_ps1))*(hN1+hp1)^2;
D2201=2*(landa_NI1+(2*mu_NI1))*(hN1^2)+2*(landa_ps1+(2*mu_ps1))*(hN1+hp1)^2;
D1201=2*(tha0_NI1+landa_NI1)*(hN1^2)+2*(tha0_ps1+landa_ps1)*(hN1+hp1)^2;
D2101=2*(tha0_NI1+landa_NI1)*(hN1^2)+2*(tha0_ps1+landa_ps1)*(hN1+hp1)^2;
D6601=(2*mu_NI1-tha0_NI1)*(hN1^2)+(2*mu_ps1-tha0_ps1)*(hN1+hp1)^2;Nxp01=2*e31p1*Ezp1*hp1+2*e31_ps1*Ezp1; 
Ntp01=2*e32p1*Ezp1*hp1+2*e32_ps1*Ezp1;E11N01=(1/3)*((nuN1*(tha0_ps1+tha0_NI1))/((1-nuN1)*(hN1+hp1)))*(2*hN1^3);
E11p01=(1/3)*((nup1*(tha0_ps1+tha0_NI1))/((1-nup1)*(hN1+hp1)))*((-hN1)^3-(-hN1-hp1)^3)+(1/3)*((nup1*(tha0_ps1+tha0_NI1))/((1-nup1)*(hN1+hp1)))*((hN1+hp1)^3-hN1^3);
G11N01=(1/3)*((nuN1*(ro_ps1+ro_NI1))/((1-nuN1)*(hN1+hp1)))*(2*hN1^3);
G11p01=(1/3)*((nup1*(ro_ps1+ro_NI1))/((1-nup1)*(hN1+hp1)))*((-hN1)^3-(-hN1-hp1)^3)+(1/3)*((nup1*(ro_ps1+ro_NI1))/((1-nup1)*(hN1+hp1)))*((hN1+hp1)^3-hN1^3);
Mxp01=(1/2)*e31p1*Ezp1*((-hN1)^2-(-hN1-hp1)^2)+(1/2)*e31p1*Ezp1*((hN1+hp1)^2-(hN1)^2)+2*e31_ps1*Ezp1*(hN1+hp1);
Mtp01=(1/2)*e32p1*Ezp1*((-hN1)^2-(-hN1-hp1)^2)+(1/2)*e32p1*Ezp1*((hN1+hp1)^2-(hN1)^2)+2*e32_ps1*Ezp1*(hN1+hp1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Dimentionless parameters layer 1
A11Nbar1=A11N1/A11N1; A22Nbar1=A22N1/A11N1; A21Nbar1=A21N1/A11N1; A12Nbar1=A12N1/A11N1; A66Nbar1=A66N1/A11N1; 
D11Nbar1=D11N1/(A11N1*hN1^2);D22Nbar1=D22N1/(A11N1*hN1^2);D12Nbar1=D12N1/(A11N1*hN1^2); D21Nbar1=D21N1/(A11N1*hN1^2);  
D66Nbar1=D66N1/(A11N1*hN1^2);A11pbar1=A11p1/A11N1; A22pbar1=A22p1/A11N1; A12pbar1=A12p1/A11N1; A21pbar1=A21p1/A11N1; 
A66pbar1=A66p1/A11N1; D11pbar1=D11p1/(A11N1*hN1^2); D12pbar1=D12p1/(A11N1*hN1^2); D21pbar1=D21p1/(A11N1*hN1^2); 
D22pbar1=D22p1/(A11N1*hN1^2); D66pbar1=D66p1/(A11N1*hN1^2); A110bar1=A1101/A11N1;A220bar1=A2201/A11N1; A120bar1=A1201/A11N1;
A210bar1=A2101/A11N1; A660bar1=A6601/A11N1;D110bar1=D1101/(A11N1*hN1^2);D220bar1=D2201/(A11N1*hN1^2);D120bar1=D1201/(A11N1*hN1^2);
D210bar1=D2101/(A11N1*hN1^2); D660bar1=D6601/(A11N1*hN1^2); Nxp0bar1=Nxp01/A11N1; Ntp0bar1=Ntp01/A11N1;
for q1 = 1 : length(L)
bbar1=b1/L(q1);
E11N0bar1=E11N01/(A11N1*hN1^2);E11p0bar1=E11p01/(A11N1*hN1^2); G11N0bar1=G11N01/(roN1*hN1^3);G11p0bar1=G11p01/(roN1*hN1^3);
m01=L(q1)/R1;m11=L(q1)/hN1;m21=hN1/R1; m31=I1/(2*roN1*hN1);tha0bar_NI1=tha0_NI1/A11N1;tha0bar_ps1=tha0_ps1/A11N1;Rbar1=R1/L(q1);
Mxp0bar1=Mxp01/(A11N1*hN1); Mtp0bar1=Mtp01/(A11N1*hN1);Omega1=sqrt(A11N1/(2*roN1*hN1*L(q1)^2)); Cwbar1=(Cw1*Omega1*L(q1)^2)/(m31*A11N1); 
Kbarw1=(Kw1*L(q1)^2)/(A11N1*m31);Kbarp1=(Kp1)/(A11N1*m31);Vbar_dc1=V_dc1/Vb01;Vbar_ac1=V_ac1/Vb01; 
Febar1=(pi*m11^2*Vb01^2*Upsilon1)/(m31*A11N1); 
CbarvdwL1=(CvdwL1*L(q1)^2)/(m31*A11N1); CbarvdwNL1=(CvdwNL1*L(q1)^2*hN1^2)/(m31*A11N1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% alpha coefficients layer 1
alpha11=(1/m31)*(A11Nbar1+A11pbar1+A110bar1);alpha21=(m01^2/m31)*(A66Nbar1+A66pbar1+A660bar1);
alpha31=(m01/(m31))*(A12Nbar1+A12pbar1+A120bar1+A21Nbar1+A21pbar1+A210bar1);alpha41=2*(m01/m31)*(A66Nbar1+A66pbar1+A660bar1);
alpha51=(m01/(m31))*(A12Nbar1+A12pbar1+A120bar1+A21Nbar1+A21pbar1+A210bar1);
alpha61=(1/(m11*m31))*(A11Nbar1+A11pbar1+A110bar1-(tha0bar_NI1+tha0bar_ps1));
alpha71=((m01*m21)/(2*m31))*(A12Nbar1+A12pbar1+A120bar1+A21Nbar1+A21pbar1+A210bar1);
alpha81=(2*(m01*m21)/m31)*(A66Nbar1+A66pbar1+A660bar1);alpha91=(m01^2/m31)*(A22Nbar1+A22pbar1+A220bar1);
alpha101=((m01^2*m21)/(m31))*(A22Nbar1+A22pbar1+A220bar1-(tha0bar_NI1+tha0bar_ps1));
alpha111=(m21/(2*m31))*(A12Nbar1+A12pbar1+A120bar1+A21Nbar1+A21pbar1+A210bar1);
alpha121=((2*m01^2)/m31)*(A22Nbar1+A22pbar1+A220bar1-(tha0bar_NI1+tha0bar_ps1));alpha131=(1/m31)*(A66Nbar1+A66pbar1+A660bar1);
alpha141=((2*m21)/m31)*(A66Nbar1+A66pbar1+A660bar1);alpha151=((m01^2)/m31)*(A22Nbar1+A22pbar1+A220bar1-2*(tha0bar_NI1+tha0bar_ps1));
alpha161=(1/(4*m11^2*m31))*(A11Nbar1+A11pbar1+A110bar1-2*(tha0bar_NI1+tha0bar_ps1));
alpha171=((m01^2*m21^2)/(4*m31))*(A22Nbar1+A22pbar1+A220bar1-2*(tha0bar_NI1+tha0bar_ps1));
alpha181=((m21^2)/(4*m31))*(4*(A66Nbar1+A66pbar1+A660bar1)+A12Nbar1+A12pbar1+A120bar1+A21Nbar1+A21pbar1+A210bar1);
alpha191=((m21)/(2*m31))*(A12Nbar1+A12pbar1+A120bar1+A21Nbar1+A21pbar1+A210bar1);
alpha201=((m01^2*m21)/m31)*(A22Nbar1+A22pbar1+A220bar1-2*(tha0bar_NI1+tha0bar_ps1));
alpha211=(1/(m11^2*m31))*((D11Nbar1+D11pbar1+D110bar1)-(E11N0bar1+E11p0bar1));
alpha221=((m01^2*m21^2)/m31)*((D22Nbar1+D22pbar1+D220bar1)-(E11N0bar1+E11p0bar1));alpha231=((4*m21^2)/m31)*(D66Nbar1+D66pbar1+D660bar1);
alpha241=((m21^2)/m31)*((D12Nbar1+D12pbar1+D120bar1+D21Nbar1+D21pbar1+D210bar1)-2*(E11N0bar1+E11p0bar1));
alpha251=((m01*m11)/(m31))*(2*(tha0bar_NI1+tha0bar_ps1)-Ntp0bar1);alpha261=((m11)/(m31))*(2*(tha0bar_NI1+tha0bar_ps1)-Nxp0bar1);
alpha271=((m01*m11)/(m31))*(2*(tha0bar_NI1+tha0bar_ps1)-Ntp0bar1);alpha281=(1/(2*m31))*(2*(tha0bar_NI1+tha0bar_ps1)-Nxp0bar1);
alpha291=((m01^2)/(2*m31))*(2*(tha0bar_NI1+tha0bar_ps1)-Ntp0bar1);alpha301=(1/(m31))*Mxp0bar1;alpha311=((m01^2)/(m31))*Mtp0bar1;
alpha321=(1/(2*m11^2*m31))*(G11N0bar1+G11p0bar1);alpha331=(m21^2/(2*m31))*(G11N0bar1+G11p0bar1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Geometric parameters layer 2
A11N2=2*hN2*C11N2; A22N2=2*hN2*C22N2; A21N2=2*hN2*C21N2; A12N2=2*hN2*C12N2; A66N2=2*hN2*C66N2;
D11N2=(2/3)*C11N2*hN2^3;D22N2=(2/3)*C22N2*hN2^3;D12N2=(2/3)*C12N2*hN2^3; D21N2=(2/3)*C21N2*hN2^3;  
D66N2=(2/3)*C66N2*hN2^3;A11p2=2*hp2*C11p2; A22p2=2*hp2*C22p2; A12p2=2*hp2*C12p2; A21p2=2*hp2*C21p2; A66p2=2*hp2*C66p2;
D11p2=(C11p2/3)*((-hN2)^3-(-hN2-hp2)^3)+(C11p2/3)*((hN2+hp2)^3-(hN2)^3);D12p2=(C12p2/3)*((-hN2)^3-(-hN2-hp2)^3)+(C12p2/3)*((hN2+hp2)^3-(hN2)^3);
D21p2=(C21p2/3)*((-hN2)^3-(-hN2-hp2)^3)+(C21p2/3)*((hN2+hp2)^3-(hN2)^3);D22p2=(C22p2/3)*((-hN2)^3-(-hN2-hp2)^3)+(C22p2/3)*((hN2+hp2)^3-(hN2)^3);
D66p2=(C66p2/3)*((-hN2)^3-(-hN2-hp2)^3)+(C66p2/3)*((hN2+hp2)^3-(hN2)^3);
A1102=2*(landa_NI2+(2*mu_NI2))+2*(landa_ps2+(2*mu_ps2));A2202=2*(landa_NI2+(2*mu_NI2))+2*(landa_ps2+(2*mu_ps2));
A1202=2*(tha0_NI2+landa_NI2)+2*(tha0_ps2+landa_ps2);A2102=2*(tha0_NI2+landa_NI2)+2*(tha0_ps2+landa_ps2);
A6602=2*mu_NI2-tha0_NI2+2*mu_ps2-tha0_ps2;D1102=2*(landa_NI2+(2*mu_NI2))*(hN2^2)+2*(landa_ps2+(2*mu_ps2))*(hN2+hp2)^2;
D2202=2*(landa_NI2+(2*mu_NI2))*(hN2^2)+2*(landa_ps2+(2*mu_ps2))*(hN2+hp2)^2;
D1202=2*(tha0_NI2+landa_NI2)*(hN2^2)+2*(tha0_ps2+landa_ps2)*(hN2+hp2)^2;
D2102=2*(tha0_NI2+landa_NI2)*(hN2^2)+2*(tha0_ps2+landa_ps2)*(hN2+hp2)^2;
D6602=(2*mu_NI2-tha0_NI2)*(hN2^2)+(2*mu_ps2-tha0_ps2)*(hN2+hp2)^2;Nxp02=2*e31p2*Ezp2*hp2+2*e31_ps2*Ezp2; 
Ntp02=2*e32p2*Ezp2*hp2+2*e32_ps2*Ezp2;E11N02=(1/3)*((nuN2*(tha0_ps2+tha0_NI2))/((1-nuN2)*(hN2+hp2)))*(2*hN2^3);
E11p02=(1/3)*((nup2*(tha0_ps2+tha0_NI2))/((1-nup2)*(hN2+hp2)))*((-hN2)^3-(-hN2-hp2)^3)+(1/3)*((nup2*(tha0_ps2+tha0_NI2))/((1-nup2)*(hN2+hp2)))*((hN2+hp2)^3-hN2^3);
G11N02=(1/3)*((nuN2*(ro_ps2+ro_NI2))/((1-nuN2)*(hN2+hp2)))*(2*hN2^3);
G11p02=(1/3)*((nup2*(ro_ps2+ro_NI2))/((1-nup2)*(hN2+hp2)))*((-hN2)^3-(-hN2-hp2)^3)+(1/3)*((nup2*(ro_ps2+ro_NI2))/((1-nup2)*(hN2+hp2)))*((hN2+hp2)^3-hN2^3);
Mxp02=(1/2)*e31p2*Ezp2*((-hN2)^2-(-hN2-hp2)^2)+(1/2)*e31p2*Ezp2*((hN2+hp2)^2-(hN2)^2)+2*e31_ps2*Ezp2*(hN2+hp2);
Mtp02=(1/2)*e32p2*Ezp2*((-hN2)^2-(-hN2-hp2)^2)+(1/2)*e32p2*Ezp2*((hN2+hp2)^2-(hN2)^2)+2*e32_ps2*Ezp2*(hN2+hp2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Dimentionless parameters layer 2
A11Nbar2=A11N2/A11N2; A22Nbar2=A22N2/A11N2; A21Nbar2=A21N2/A11N2; A12Nbar2=A12N2/A11N2; A66Nbar2=A66N2/A11N2; 
D11Nbar2=D11N2/(A11N2*hN2^2);D22Nbar2=D22N2/(A11N2*hN2^2);D12Nbar2=D12N2/(A11N2*hN2^2); D21Nbar2=D21N2/(A11N2*hN2^2);  
D66Nbar2=D66N2/(A11N2*hN2^2);A11pbar2=A11p2/A11N2; A22pbar2=A22p2/A11N2; A12pbar2=A12p2/A11N2; A21pbar2=A21p2/A11N2; 
A66pbar2=A66p2/A11N2; D11pbar2=D11p2/(A11N2*hN2^2); D12pbar2=D12p2/(A11N2*hN2^2); D21pbar2=D21p2/(A11N2*hN2^2); 
D22pbar2=D22p2/(A11N2*hN2^2); D66pbar2=D66p2/(A11N2*hN2^2); A110bar2=A1102/A11N2;A220bar2=A2202/A11N2; A120bar2=A1202/A11N2;
A210bar2=A2102/A11N2; A660bar2=A6602/A11N2;D110bar2=D1102/(A11N2*hN2^2);D220bar2=D2202/(A11N2*hN2^2);D120bar2=D1202/(A11N2*hN2^2);
D210bar2=D2102/(A11N2*hN2^2); D660bar2=D6602/(A11N2*hN2^2); Nxp0bar2=Nxp02/A11N2; Ntp0bar2=Ntp02/A11N2;bbar2=b1/L(q1);
E11N0bar2=E11N02/(A11N2*hN2^2);E11p0bar2=E11p02/(A11N2*hN2^2); G11N0bar2=G11N02/(roN2*hN2^3);G11p0bar2=G11p02/(roN2*hN2^3);
m02=L(q1)/R2;m12=L(q1)/hN2;m22=hN2/R2; m32=I2/(2*roN2*hN2);tha0bar_NI2=tha0_NI2/A11N2;tha0bar_ps2=tha0_ps2/A11N2;Rbar2=R2/L(q1);
Mxp0bar2=Mxp02/(A11N2*hN2); Mtp0bar2=Mtp02/(A11N2*hN2);Omega2=sqrt(A11N2/(2*roN2*hN2*L(q1)^2)); Cwbar2=(Cw2*Omega2*L(q1)^2)/(m32*A11N2); 
Kbarw2=(Kw2*L(q1)^2)/(A11N2*m32);Kbarp2=(Kp2)/(A11N2*m32);Vbar_dc2=V_dc2/Vb02;Vbar_ac2=V_ac2/Vb02; 
Febar2=(pi*m12^2*Vb02^2*Upsilon2)/(m32*A11N2); 
CbarvdwL2=(CvdwL2*L(q1)^2)/(m32*A11N2); CbarvdwNL2=(CvdwNL2*L(q1)^2*hN2^2)/(m32*A11N2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% alpha coefficients layer 2
alpha12=(1/m32)*(A11Nbar2+A11pbar2+A110bar2);alpha22=(m02^2/m32)*(A66Nbar2+A66pbar2+A660bar2);
alpha32=(m02/(m32))*(A12Nbar2+A12pbar2+A120bar2+A21Nbar2+A21pbar2+A210bar2);alpha42=2*(m02/m32)*(A66Nbar2+A66pbar2+A660bar2);
alpha52=(m02/(m32))*(A12Nbar2+A12pbar2+A120bar2+A21Nbar2+A21pbar2+A210bar2);
alpha62=(1/(m12*m32))*(A11Nbar2+A11pbar2+A110bar2-(tha0bar_NI2+tha0bar_ps2));
alpha72=((m02*m22)/(2*m32))*(A12Nbar2+A12pbar2+A120bar2+A21Nbar2+A21pbar2+A210bar2);
alpha82=(2*(m02*m22)/m32)*(A66Nbar2+A66pbar2+A660bar2);alpha92=(m02^2/m32)*(A22Nbar2+A22pbar2+A220bar2);
alpha102=((m02^2*m22)/(m32))*(A22Nbar2+A22pbar2+A220bar2-(tha0bar_NI2+tha0bar_ps2));
alpha112=(m22/(2*m32))*(A12Nbar2+A12pbar2+A120bar2+A21Nbar2+A21pbar2+A210bar2);
alpha122=((2*m02^2)/m32)*(A22Nbar2+A22pbar2+A220bar2-(tha0bar_NI2+tha0bar_ps2));alpha132=(1/m32)*(A66Nbar2+A66pbar2+A660bar2);
alpha142=((2*m22)/m32)*(A66Nbar2+A66pbar2+A660bar2);alpha152=((m02^2)/m32)*(A22Nbar2+A22pbar2+A220bar2-2*(tha0bar_NI2+tha0bar_ps2));
alpha162=(1/(4*m12^2*m32))*(A11Nbar2+A11pbar2+A110bar2-2*(tha0bar_NI2+tha0bar_ps2));
alpha172=((m02^2*m22^2)/(4*m32))*(A22Nbar2+A22pbar2+A220bar2-2*(tha0bar_NI2+tha0bar_ps2));
alpha182=((m22^2)/(4*m32))*(4*(A66Nbar2+A66pbar2+A660bar2)+A12Nbar2+A12pbar2+A120bar2+A21Nbar2+A21pbar2+A210bar2);
alpha192=((m22)/(2*m32))*(A12Nbar2+A12pbar2+A120bar2+A21Nbar2+A21pbar2+A210bar2);
alpha202=((m02^2*m22)/m32)*(A22Nbar2+A22pbar2+A220bar2-2*(tha0bar_NI2+tha0bar_ps2));
alpha212=(1/(m12^2*m32))*((D11Nbar2+D11pbar2+D110bar2)-(E11N0bar2+E11p0bar2));
alpha222=((m02^2*m22^2)/m32)*((D22Nbar2+D22pbar2+D220bar2)-(E11N0bar2+E11p0bar2));alpha232=((4*m22^2)/m32)*(D66Nbar2+D66pbar2+D660bar2);
alpha242=((m22^2)/m32)*((D12Nbar2+D12pbar2+D120bar2+D21Nbar2+D21pbar2+D210bar2)-2*(E11N0bar2+E11p0bar2));
alpha252=((m02*m12)/(m32))*(2*(tha0bar_NI2+tha0bar_ps2)-Ntp0bar2);alpha262=((m12)/(m32))*(2*(tha0bar_NI2+tha0bar_ps2)-Nxp0bar2);
alpha272=((m02*m12)/(m32))*(2*(tha0bar_NI2+tha0bar_ps2)-Ntp0bar2);alpha282=(1/(2*m32))*(2*(tha0bar_NI2+tha0bar_ps2)-Nxp0bar2);
alpha292=((m02^2)/(2*m32))*(2*(tha0bar_NI2+tha0bar_ps2)-Ntp0bar2);alpha302=(1/(m32))*Mxp0bar2;alpha312=((m02^2)/(m32))*Mtp0bar2;
alpha322=(1/(2*m12^2*m32))*(G11N0bar2+G11p0bar2);alpha332=(m22^2/(2*m32))*(G11N0bar2+G11p0bar2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Geometric parameters layer 3
A11N3=2*hN3*C11N3; A22N3=2*hN3*C22N3; A21N3=2*hN3*C21N3; A12N3=2*hN3*C12N3; A66N3=2*hN3*C66N3;
D11N3=(2/3)*C11N3*hN3^3;D22N3=(2/3)*C22N3*hN3^3;D12N3=(2/3)*C12N3*hN3^3; D21N3=(2/3)*C21N3*hN3^3;D66N3=(2/3)*C66N3*hN3^3;
A11p3=2*hp3*C11p3; A22p3=2*hp3*C22p3; A12p3=2*hp3*C12p3; A21p3=2*hp3*C21p3; A66p3=2*hp3*C66p3;
D11p3=(C11p3/3)*((-hN3)^3-(-hN3-hp3)^3)+(C11p3/3)*((hN3+hp3)^3-(hN3)^3);  
D12p3=(C12p3/3)*((-hN3)^3-(-hN3-hp3)^3)+(C12p3/3)*((hN3+hp3)^3-(hN3)^3);
D21p3=(C21p3/3)*((-hN3)^3-(-hN3-hp3)^3)+(C21p3/3)*((hN3+hp3)^3-(hN3)^3);  
D22p3=(C22p3/3)*((-hN3)^3-(-hN3-hp3)^3)+(C22p3/3)*((hN3+hp3)^3-(hN3)^3);
D66p3=(C66p3/3)*((-hN3)^3-(-hN3-hp3)^3)+(C66p3/3)*((hN3+hp3)^3-(hN3)^3);
A1103=2*(landa_NI3+(2*mu_NI3))+2*(landa_ps3+(2*mu_ps3));A2203=2*(landa_NI3+(2*mu_NI3))+2*(landa_ps3+(2*mu_ps3));
A1203=2*(tha0_NI3+landa_NI3)+2*(tha0_ps3+landa_ps3);A2103=2*(tha0_NI3+landa_NI3)+2*(tha0_ps3+landa_ps3);
A6603=2*mu_NI3-tha0_NI3+2*mu_ps3-tha0_ps3;D1103=2*(landa_NI3+(2*mu_NI3))*(hN3^2)+2*(landa_ps3+(2*mu_ps3))*(hN3+hp3)^2;
D2203=2*(landa_NI3+(2*mu_NI3))*(hN3^2)+2*(landa_ps3+(2*mu_ps3))*(hN3+hp3)^2;
D1203=2*(tha0_NI3+landa_NI3)*(hN3^2)+2*(tha0_ps3+landa_ps3)*(hN3+hp3)^2;
D2103=2*(tha0_NI3+landa_NI3)*(hN3^2)+2*(tha0_ps3+landa_ps3)*(hN3+hp3)^2;
D6603=(2*mu_NI3-tha0_NI3)*(hN3^2)+(2*mu_ps3-tha0_ps3)*(hN3+hp3)^2;Nxp03=2*e31p3*Ezp3*hp3+2*e31_ps3*Ezp3; 
Ntp03=2*e32p3*Ezp3*hp3+2*e32_ps3*Ezp3;
E11N03=(1/3)*((nuN3*(tha0_ps3+tha0_NI3))/((1-nuN3)*(hN3+hp3)))*(2*hN3^3);
E11p03=(1/3)*((nup3*(tha0_ps3+tha0_NI3))/((1-nup3)*(hN3+hp3)))*((-hN3)^3-(-hN3-hp3)^3)+(1/3)*((nup3*(tha0_ps3+tha0_NI3))/((1-nup3)*(hN3+hp3)))*((hN3+hp3)^3-hN3^3);
G11N03=(1/3)*((nuN3*(ro_ps3+ro_NI3))/((1-nuN3)*(hN3+hp3)))*(2*hN3^3);
G11p03=(1/3)*((nup3*(ro_ps3+ro_NI3))/((1-nup3)*(hN3+hp3)))*((-hN3)^3-(-hN3-hp3)^3)+(1/3)*((nup3*(ro_ps3+ro_NI3))/((1-nup3)*(hN3+hp3)))*((hN3+hp3)^3-hN3^3);
Mxp03=(1/2)*e31p3*Ezp3*((-hN3)^2-(-hN3-hp3)^2)+(1/2)*e31p3*Ezp3*((hN3+hp3)^2+(hN3)^2)+2*e31_ps3*Ezp3*(hN3+hp3);
Mtp03=(1/2)*e32p3*Ezp3*((-hN3)^2-(-hN3-hp3)^2)+(1/2)*e32p3*Ezp3*((hN3+hp3)^2+(hN3)^2)+2*e32_ps3*Ezp3*(hN3+hp3);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Dimentionless parameters layer 3
A11Nbar3=A11N3/A11N3; A22Nbar3=A22N3/A11N3; A21Nbar3=A21N3/A11N3; A12Nbar3=A12N3/A11N3; A66Nbar3=A66N3/A11N3; 
D11Nbar3=D11N3/(A11N3*hN3^2);D22Nbar3=D22N3/(A11N3*hN3^2);D12Nbar3=D12N3/(A11N3*hN3^2); D21Nbar3=D21N3/(A11N3*hN3^2);  
D66Nbar3=D66N3/(A11N3*hN3^2);A11pbar3=A11p3/A11N3; A22pbar3=A22p3/A11N3; A12pbar3=A12p3/A11N3; A21pbar3=A21p3/A11N3; 
A66pbar3=A66p3/A11N3;D11pbar3=D11p3/(A11N3*hN3^2); D12pbar3=D12p3/(A11N3*hN3^2); D21pbar3=D21p3/(A11N3*hN3^2); 
D22pbar3=D22p3/(A11N3*hN3^2);D66pbar3=D66p3/(A11N3*hN3^2); A110bar3=A1103/A11N3;A220bar3=A2203/A11N3; A120bar3=A1203/A11N3;
A210bar3=A2103/A11N3; A660bar3=A6603/A11N3;D110bar3=D1103/(A11N3*hN3^2);D220bar3=D2203/(A11N3*hN3^2);D120bar3=D1203/(A11N3*hN3^2);
D210bar3=D2103/(A11N3*hN3^2); D660bar3=D6603/(A11N3*hN3^2); Nxp0bar3=Nxp03/A11N3; Ntp0bar3=Ntp03/A11N3;
E11N0bar3=E11N03/(A11N3*hN3^2);E11p0bar3=E11p03/(A11N3*hN3^2); G11N0bar3=G11N03/(roN3*hN3^3);G11p0bar3=G11p03/(roN3*hN3^3);
m03=L(q1)/R3;m13=L(q1)/hN3;m23=hN3/R3;m33=I3/(2*roN3*hN3); tha0bar_NI3=tha0_NI3/A11N3;tha0bar_ps3=tha0_ps3/A11N3;
Mxp0bar3=Mxp03/(A11N3*hN3); Mtp0bar3=Mtp03/(A11N3*hN3);Omega2=sqrt(A11N3/(2*roN3*hN3*L(q1)^2)); Cwbar3=(Cw3*Omega2*L(q1)^2)/(m33*A11N3); 
Kbarw3=(Kw3*L(q1)^2)/(A11N3*m33);Kbarp3=(Kp3)/(A11N3*m33);Vbar_dc3=V_dc3/Vb03;Vbar_ac3=V_ac3/Vb03; 
CbarvdwL3=(CvdwL3*L(q1)^2)/(m33*A11N3); CbarvdwNL3=(CvdwNL3*L(q1)^2*hN3^2)/(m33*A11N3);
% CbarvdwL1=9e2; CbarvdwL2=9e2; CbarvdwL3=9e2; CbarvdwNL1=5e0; CbarvdwNL2=5e0; CbarvdwNL3=5e0; 

%%%%%%%%%%%%%%%%%%%%%%%%%%% Electrostatic approximation
Febar3=(pi*m13^2*Vb03^2*Upsilon3)/(m33*A11N3);
wbar = linspace(0 , 9.95e0, 2e5);
bbar3=b3/L(q1);Rbar3=R3/b3;m43=b3/hN3; ydata = (sqrt((m13*bbar3-wbar).*((2*Rbar3*m43)+m13*bbar3-wbar)).*(acosh(1+((m13*bbar3-wbar)/(Rbar3*m43)))).^2).^-1;
x0 = ones(4 , 1); f = @(C_,wbar)C_(1)+C_(2)*wbar+C_(3)*wbar.^2+C_(4)*wbar.^3;
C_ = lsqcurvefit(f,x0,wbar,ydata);

%%%%%%%%%%%%%%%%%%%%%%%%%%%
FeDCbar=Febar3*Vbar_dc3^2;Febar23=FeDCbar*C_(2);Febar33=FeDCbar*C_(3);Febar43=FeDCbar*C_(4);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% alpha coefficients layer 3
alpha13=(1/m33)*(A11Nbar3+A11pbar3+A110bar3);alpha23=(m03^2/m33)*(A66Nbar3+A66pbar3+A660bar3);
alpha33=(m03/(m33))*(A12Nbar3+A12pbar3+A120bar3+A21Nbar3+A21pbar3+A210bar3);alpha43=2*(m03/m33)*(A66Nbar3+A66pbar3+A660bar3);
alpha53=(m03/(m33))*(A12Nbar3+A12pbar3+A120bar3+A21Nbar3+A21pbar3+A210bar3);
alpha63=(1/(m13*m33))*(A11Nbar3+A11pbar3+A110bar3-(tha0bar_NI3+tha0bar_ps3));
alpha73=((m03*m23)/(2*m33))*(A12Nbar3+A12pbar3+A120bar3+A21Nbar3+A21pbar3+A210bar3);
alpha83=(2*(m03*m23)/m33)*(A66Nbar3+A66pbar3+A660bar3);alpha93=(m03^2/m33)*(A22Nbar3+A22pbar3+A220bar3);
alpha103=((m03^2*m23)/(m33))*(A22Nbar3+A22pbar3+A220bar3-(tha0bar_NI3+tha0bar_ps3));
alpha113=(m23/(2*m33))*(A12Nbar3+A12pbar3+A120bar3+A21Nbar3+A21pbar3+A210bar3);
alpha123=((2*m03^2)/m33)*(A22Nbar3+A22pbar3+A220bar3-(tha0bar_NI3+tha0bar_ps3));alpha133=(1/m33)*(A66Nbar3+A66pbar3+A660bar3);
alpha143=((2*m23)/m33)*(A66Nbar3+A66pbar3+A660bar3);alpha153=((m03^2)/m33)*(A22Nbar3+A22pbar3+A220bar3-2*(tha0bar_NI3+tha0bar_ps3));
alpha163=(1/(4*m13^2*m33))*(A11Nbar3+A11pbar3+A110bar3-2*(tha0bar_NI3+tha0bar_ps3));
alpha173=((m03^2*m23^2)/(4*m33))*(A22Nbar3+A22pbar3+A220bar3-2*(tha0bar_NI3+tha0bar_ps3));
alpha183=((m23^2)/(4*m33))*(4*(A66Nbar3+A66pbar3+A660bar3)+A12Nbar3+A12pbar3+A120bar3+A21Nbar3+A21pbar3+A210bar3);
alpha193=((m23)/(2*m33))*(A12Nbar3+A12pbar3+A120bar3+A21Nbar3+A21pbar3+A210bar3);
alpha203=((m03^2*m23)/m33)*(A22Nbar3+A22pbar3+A220bar3-2*(tha0bar_NI3+tha0bar_ps3));
alpha213=(1/(m13^2*m33))*((D11Nbar3+D11pbar3+D110bar3)-(E11N0bar3+E11p0bar3));
alpha223=((m03^2*m23^2)/m33)*((D22Nbar3+D22pbar3+D220bar3)-(E11N0bar3+E11p0bar3));
alpha233=((4*m23^2)/m33)*(D66Nbar3+D66pbar3+D660bar3);
alpha243=((m23^2)/m33)*((D12Nbar3+D12pbar3+D120bar3+D21Nbar3+D21pbar3+D210bar3)-2*(E11N0bar3+E11p0bar3));
alpha253=((m03*m13)/(m33))*(2*(tha0bar_NI3+tha0bar_ps3)-Ntp0bar3);
alpha263=((m13)/(m33))*(2*(tha0bar_NI3+tha0bar_ps3)-Nxp0bar3);
alpha273=((m03*m13)/(m33))*(2*(tha0bar_NI3+tha0bar_ps3)-Ntp0bar3);alpha283=(1/(2*m33))*(2*(tha0bar_NI3+tha0bar_ps3)-Nxp0bar3);
alpha293=((m03^2)/(2*m33))*(2*(tha0bar_NI3+tha0bar_ps3)-Ntp0bar3);alpha303=(1/(m33))*Mxp0bar3;alpha313=((m03^2)/(m33))*Mtp0bar3;
alpha323=(1/(2*m13^2*m33))*(G11N0bar3+G11p0bar3);alpha333=(m23^2/(2*m33))*(G11N0bar3+G11p0bar3);

%%%%%%%%%%%%%%%%%%%%%%%%%%% Transverse Structural Matrices (u1,v1,w1)
%%%%%%%%%%%%%%%%%%%%%%%%%%% U1
Mu1u1 = Muu1_1;
Ku1u1 = alpha11*Kuu1_1+alpha21*Kuu2_1;
Ku1v1 = (1/2)*alpha31*Kuv1_1+(1/2)*alpha41*Kuv2_1;
Ku1w1 =(1/2)*alpha51*Kuw1_1;
NLuw1 = (1/2)*alpha61*NLuw1_1+(1/2)*alpha71*NLuw2_1+(1/2)*alpha81*NLuw3_1;
Fup1 = (1/2)*alpha261*Fu1_1;

%%%%%%%%%%%%%%%%%%%%%%%%%%% V1
Mv1v1 = Mvv1_1;
Kv1u1 =(1/2)*alpha31*Kvu1_1+(1/2)*alpha41*Kvu2_1;
Kv1v1 = alpha91*Kvv1_1+alpha131*Kvv2_1;
Kv1w1 = (1/2)*alpha121*Kvw1_1;
NLvw1 = (1/2)*alpha101*NLvw1_1+(1/2)*alpha111*NLvw2_1+(1/2)*alpha141*NLvw3_1;
Fvp1 = (1/2)*alpha271*Fv1_1;

%%%%%%%%%%%%%%%%%%%%%%%%%%% W1
Mw1w1 = Mww1_1+(1/2)*alpha321*Mww2_1+(1/2)*alpha331*Mww3_1;
Kw1u1 = (1/2)*alpha51*Kwu1_1;
Kw1v1 = (1/2)*alpha121*Kwv1_1;
Kw1w1 = alpha151*Kww1_1+alpha211*Kww2_1+alpha221*Kww3_1+alpha231*Kww4_1+(1/2)*alpha241*Kww5_1...
       +(1/2)*alpha241*Kww6_1+alpha281*Kww7_1+(1/2)*CbarvdwL1*Kwvdw_1;
Kw1w2 = -(1/2)*CbarvdwL1*Kwvdw_1;
NLwu1 = alpha61*NLwu1_1+alpha71*NLwu2_1+(1/2)*alpha81*NLwu3_1+(1/2)*alpha81*NLwu4_1;
NLwv1 = alpha101*NLwv1_1+alpha111*NLwv2_1+(1/2)*alpha141*NLwv3_1+(1/2)*alpha141*NLwv4_1;
NLww1 = (1/2)*alpha191*NLww1_1+alpha191*NLww2_1+(1/2)*alpha201*NLww3_1+alpha201*NLww4_1;
NLwww1 = 2*alpha161*NLwww1_1+2*alpha171*NLwww2_1+alpha181*NLwww3_1+alpha181*NLwww4_1;
Fwp1 = (1/2)*alpha251*Fw1_1+(1/2)*alpha301*Fw2_1+(1/2)*alpha311*Fw3_1;

%%%%%%%%%%%%%%%%%%%%%%%%%%% U2
Mu2u2 = Muu1_2;
Ku2u2 = alpha12*Kuu1_2+alpha22*Kuu2_2;
Ku2v2 = (1/2)*alpha32*Kuv1_2+(1/2)*alpha42*Kuv2_2;
Ku2w2 =(1/2)*alpha52*Kuw1_2;
NLuw2 = (1/2)*alpha62*NLuw1_2+(1/2)*alpha72*NLuw2_2+(1/2)*alpha82*NLuw3_2;
Fup2 = (1/2)*alpha262*Fu1_2;

%%%%%%%%%%%%%%%%%%%%%%%%%%% V2
Mv2v2 = Mvv1_2;
Kv2u2 =(1/2)*alpha32*Kvu1_2+(1/2)*alpha41*Kvu2_2;
Kv2v2 = alpha92*Kvv1_2+alpha132*Kvv2_2;
Kv2w2 = (1/2)*alpha122*Kvw1_2;
NLvw2 = (1/2)*alpha102*NLvw1_2+(1/2)*alpha112*NLvw2_2+(1/2)*alpha142*NLvw3_2;
Fvp2 = (1/2)*alpha272*Fv1_2;

%%%%%%%%%%%%%%%%%%%%%%%%%%% w2
Mw2w2 = Mww1_2+(1/2)*alpha322*Mww2_2+(1/2)*alpha332*Mww3_2;
Kw2u2 = (1/2)*alpha52*Kwu1_2;
Kw2v2 = (1/2)*alpha122*Kwv1_2;
Kw2w1 = -(1/2)*CbarvdwL2*(Rbar1/Rbar2)*Kwvdw_2;
Kw2w2 = alpha152*Kww1_2+alpha212*Kww2_2+alpha221*Kww3_2+alpha232*Kww4_2+(1/2)*alpha242*Kww5_2...
       +(1/2)*alpha242*Kww6_2+alpha282*Kww7_2+(1/2)*CbarvdwL2*(Rbar1/Rbar2)*Kwvdw_2+(1/2)*CbarvdwL2*Kwvdw_2;
Kw2w3 = -(1/2)*CbarvdwL2*Kwvdw_2;
NLwu2 = alpha62*NLwu1_2+alpha72*NLwu2_2+(1/2)*alpha82*NLwu3_2+(1/2)*alpha82*NLwu4_2;
NLwv2 = alpha102*NLwv1_2+alpha112*NLwv2_2+(1/2)*alpha142*NLwv3_2+(1/2)*alpha142*NLwv4_2;
NLww2 = (1/2)*alpha192*NLww1_2+alpha192*NLww2_2+(1/2)*alpha202*NLww3_2+alpha202*NLww4_2;
NLwww2 = 2*alpha162*NLwww1_2+2*alpha172*NLwww2_2+alpha182*NLwww3_2+alpha182*NLwww4_2;
Fwp2 = (1/2)*alpha252*Fw1_2+(1/2)*alpha302*Fw2_2+(1/2)*alpha312*Fw3_2;

%%%%%%%%%%%%%%%%%%%%%%%%%%% Transverse Structural Matrices (u3,v3,w3)
%%%%%%%%%%%%%%%%%%%%%%%%%%% u3
Mu3u3 = Muu1_3;
Ku3u3 = alpha13*Kuu1_3+alpha23*Kuu2_3;
Ku3v3 = (1/2)*alpha33*Kuv1_3+(1/2)*alpha43*Kuv2_3;
Ku3w3 =(1/2)*alpha53*Kuw1_3;
NLuw3 = (1/2)*alpha63*NLuw1_3+(1/2)*alpha73*NLuw2_3+(1/2)*alpha83*NLuw3_3;
Fup3 = (1/2)*alpha263*Fu1_3;

%%%%%%%%%%%%%%%%%%%%%%%%%%% v3
Mv3v3 = Mvv1_3;
Kv3u3 = (1/2)*alpha33*Kvu1_3+(1/2)*alpha43*Kvu2_3;
Kv3v3 = alpha93*Kvv1_3+alpha133*Kvv2_3;
Kv3w3 = (1/2)*alpha123*Kvw1_3;
NLvw3 = (1/2)*alpha103*NLvw1_3+(1/2)*alpha113*NLvw2_3+(1/2)*alpha143*NLvw3_3;
Fvp3 = (1/2)*alpha273*Fv1_3;

%%%%%%%%%%%%%%%%%%%%%%%%%%% w3
Mw3w3 = Mww1_3+(1/2)*alpha323*Mww3_3+(1/2)*alpha333*Mww3_3;
Cw3w3 = Cwbar3*Cww1_3;
Kw3u3 = (1/2)*alpha53*Kwu1_3;
Kw3v3 = (1/2)*alpha123*Kwv1_3;
Kw3w2 = -(1/2)*CbarvdwL3*(Rbar2/Rbar3)*Kwvdw_3;
Kw3w3 = alpha152*Kww3_3+alpha212*Kww3_3+alpha223*Kww3_3+alpha233*Kww4_3+(1/2)*alpha243*Kww5_3+(1/2)*alpha243*Kww6_3...
       +alpha283*Kww7_3+Kbarw3*Kbarw1_3-Kbarp3*Kbarp1_3-(m03^2)*Kbarp3*Kbarp2_3-(1/2)*Febar23*Kew1_3...
       +(1/2)*CbarvdwL3*(Rbar2/Rbar3)*Kwvdw_3;
NLwu3 = alpha63*NLwu1_3+alpha73*NLwu2_3+(1/2)*alpha83*NLwu3_3+(1/2)*alpha83*NLwu4_3;
NLwv3 = alpha103*NLwv1_3+alpha113*NLwv2_3+(1/2)*alpha143*NLwv3_3+(1/2)*alpha143*NLwv4_3;
NLww3 = (1/2)*alpha193*NLww1_3+alpha193*NLww2_3+(1/2)*alpha203*NLww3_3+alpha203*NLww4_3-(1/2)*Febar33*NLew2_3;
NLwww3 = 2*alpha163*NLwww1_3+2*alpha173*NLwww2_3+alpha183*NLwww3_3+alpha183*NLwww4_3-(1/2)*Febar43*NLew3_3;
Fwp3 = (1/2)*alpha253*Fw1_3+(1/2)*alpha303*Fw2_3+(1/2)*alpha313*Fw3_3;
Fwe3 = (1/2)*FeDCbar*Fbar1_3*C_(1);

%%%%%%%%%%%%%%%%%%%%%%%%%%
tmu = (2*nu+1)*mu; tmv = (2*nv+1)*mv; tmw = (2*nw+1)*mw;
mx1 = (tmu+tmv+tmw); 
%%%%%%%%%%%%%%%%%%%%%%%%%%
M = [Mu1u1 zeros(tmu, tmv) zeros(tmu, tmw) zeros(tmu, tmu)  zeros(tmu, tmv) zeros(tmu, tmw) zeros(tmu, tmu)  zeros(tmu, tmv) zeros(tmu, tmw);...
    zeros(tmv , tmu) Mv1v1 zeros(tmv, tmw) zeros(tmv , tmu)  zeros(tmv , tmv) zeros(tmv, tmw) zeros(tmv , tmu)  zeros(tmv , tmv) zeros(tmv, tmw);...
    zeros(tmw , tmu) zeros(tmw, tmv) Mw1w1 zeros(tmw , tmu) zeros(tmw , tmv) zeros(tmw, tmw) zeros(tmw , tmu) zeros(tmw , tmv) zeros(tmw, tmw);...
    zeros(tmu , tmu) zeros(tmu, tmv) zeros(tmu, tmw) Mu2u2  zeros(tmu , tmv) zeros(tmu, tmw) zeros(tmu , tmu) zeros(tmu, tmv) zeros(tmu, tmw);...
    zeros(tmv , tmu) zeros(tmv , tmv) zeros(tmv, tmw) zeros(tmv , tmu) Mv2v2 zeros(tmv, tmw) zeros(tmv , tmu) zeros(tmv , tmv) zeros(tmv, tmw);...
    zeros(tmw , tmu) zeros(tmw, tmv) zeros(tmw, tmw) zeros(tmw , tmu) zeros(tmw, tmv) Mw2w2 zeros(tmw , tmu) zeros(tmw, tmv) zeros(tmw, tmw);...
    zeros(tmu , tmu) zeros(tmu, tmv) zeros(tmu, tmw) zeros(tmu, tmu)  zeros(tmu, tmv) zeros(tmu, tmw) Mu3u3  zeros(tmu, tmv) zeros(tmu, tmw);...
    zeros(tmv , tmu) zeros(tmv , tmv) zeros(tmv, tmw) zeros(tmv , tmu)  zeros(tmv , tmv) zeros(tmv, tmw) zeros(tmv , tmu)  Mv3v3 zeros(tmv, tmw);...
    zeros(tmw , tmu) zeros(tmw, tmv) zeros(tmw , tmw) zeros(tmw , tmu) zeros(tmw , tmv) zeros(tmw, tmw) zeros(tmw , tmu) zeros(tmw , tmv) Mw3w3];
    
K = [Ku1u1 Ku1v1 Ku1w1 zeros(tmu, tmu) zeros(tmu, tmv) zeros(tmu, tmw) zeros(tmu, tmu) zeros(tmu, tmv) zeros(tmu, tmw);...
    Kv1u1 Kv1v1 Kv1w1 zeros(tmv , tmu) zeros(tmv , tmv) zeros(tmv, tmw) zeros(tmv , tmu) zeros(tmv , tmv) zeros(tmv, tmw);...
    Kw1u1 Kw1v1 Kw1w1 zeros(tmw , tmu) zeros(tmw, tmv)  Kw1w2 zeros(tmw , tmu) zeros(tmw, tmv)  zeros(tmw, tmw);...
    zeros(tmu, tmu) zeros(tmu, tmv) zeros(tmu, tmw) Ku2u2 Ku2v2 Ku2w2 zeros(tmu, tmu) zeros(tmu, tmv) zeros(tmu, tmw);...
    zeros(tmv , tmu) zeros(tmv , tmv) zeros(tmv, tmw) Kv2u2 Kv2v2 Kv2w2 zeros(tmv , tmu) zeros(tmv , tmv) zeros(tmv, tmw);...
    zeros(tmw , tmu) zeros(tmw, tmv) Kw2w1 Kw2u2 Kw2v2 Kw2w2 zeros(tmw , tmu) zeros(tmw , tmv) Kw2w3;...
    zeros(tmu, tmu) zeros(tmu, tmv) zeros(tmu, tmw) zeros(tmu, tmu) zeros(tmu, tmv) zeros(tmu, tmw) Ku3u3 Ku3v3 Ku3w3;...
    zeros(tmv , tmu) zeros(tmv , tmv) zeros(tmv, tmw) zeros(tmv , tmu) zeros(tmv , tmv) zeros(tmv, tmw) Kv3u3 Kv3v3 Kv3w3;...
    zeros(tmw , tmu) zeros(tmw, tmv) zeros(tmw, tmw) zeros(tmw , tmu) zeros(tmw, tmv) Kw3w2 Kw3u3 Kw3v3 Kw3w3];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Natural Frequency
[V1,D] = eig(K, M);
omega = sqrt(D);
VT = V1.';
IV = V1\eye(size(V1)); IVT = VT\eye(size(VT));
M_D = VT*M*V1;
C1 = IVT*2*zeta3*M_D*omega*IV;
Freq = sort(sqrt(eig(K, M)))

%%%%%%%%%%%%%%%%%%%%% Dynamics Matrices
[V , D] = eig(K, M);
natural_fre2 = diag(D);
[natural_fre,II] = sort(sqrt(natural_fre2));
OmegaN(: , q1) = natural_fre(1 : tmw , 1)*R1/L(q1);

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(2), plot(L/R1 , OmegaN); xlabel('L/R_1'), ylabel('$\bar{\omega}$','Interpreter','Latex')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

